#include <stdio.h>
#include <stdlib.h>

#define MAXN 200005

int N, Q;
int a[MAXN];
int cnt[MAXN];

typedef struct {
    long long value;
    int count;
} Pair;

int compare(const void *p1, const void *p2) {
    Pair *a = (Pair *)p1;
    Pair *b = (Pair *)p2;
    if (a->value == b->value) return 0;
    return (a->value < b->value) ? 1 : -1; 
}

int main() {
    scanf("%d %d", &N, &Q);
    for (int i = 1; i <= N; i++) scanf("%d", &a[i]);

    int currentK = 0;
    long long totalSum = 0;

    for (int q = 0; q < Q; q++) {
        int t;
        scanf("%d", &t);
        if (t == 1) {
            int k;
            scanf("%d", &k);
            for (int i = currentK + 1; i <= k; i++) {
                cnt[a[i]]++;
                totalSum += a[i];
            }
            for (int i = currentK; i > k; i--) {
                cnt[a[i]]--;
                totalSum -= a[i];
            }
            currentK = k;

            Pair list[MAXN];
            int size = 0;
            for (int i = 1; i <= N; i++) {
                if (cnt[i] > 0) {
                    list[size].value = (long long)i * cnt[i];
                    list[size].count = cnt[i];
                    size++;
                }
            }

            qsort(list, size, sizeof(Pair), compare);

            int moves = N - k;
            long long removed = 0;
            for (int i = 0; i < size && moves > 0; i++) {
                removed += list[i].value;
                moves--;
            }

            printf("%lld\n", totalSum - removed);

        } else {
            int x, y;
            scanf("%d %d", &x, &y);
            if (x <= currentK) {
                cnt[a[x]]--;
                totalSum -= a[x];
                cnt[y]++;
                totalSum += y;
            }
            a[x] = y;
        }
    }

    return 0;
}